#!/bin/bash
# Upload file to R2 and return public URL
# Usage: ./upload-r2.sh /path/to/file [optional-remote-name]

set -e

if [ -z "$1" ]; then
  echo "Usage: $0 /path/to/file [optional-remote-name]"
  exit 1
fi

FILE_PATH="$1"
BUCKET="trace-artifacts"
R2_PUBLIC_URL="https://pub-0bf7a1971eff42b9a061b943afefcdb3.r2.dev"

if [ ! -f "$FILE_PATH" ]; then
  echo "Error: File not found: $FILE_PATH"
  exit 1
fi

# Use provided name or basename of file
if [ -n "$2" ]; then
  REMOTE_NAME="$2"
else
  REMOTE_NAME=$(basename "$FILE_PATH")
fi

# Load credentials
export CLOUDFLARE_API_TOKEN="IsWQg-M_9YJ6EoQSxCWzi_aw8ugmCzBopdOH74mH"

# Upload
echo "Uploading $FILE_PATH to R2 as $REMOTE_NAME..."
wrangler r2 object put "$BUCKET/$REMOTE_NAME" --file "$FILE_PATH"

# Return public URL
PUBLIC_URL="$R2_PUBLIC_URL/$REMOTE_NAME"

echo ""
echo "✅ Upload complete!"
echo ""
echo "Public URL:"
echo "$PUBLIC_URL"
