#!/bin/bash
# Quick Tunnel helper - exposes a local port via cloudflare tunnel
# Usage: ./start-tunnel.sh [PORT]
# Default port: 3000

PORT=${1:-3000}
LOG=/tmp/cf-tunnel.log
PID_FILE=/tmp/cf-tunnel.pid

# Kill existing tunnel if running
[ -f "$PID_FILE" ] && kill $(cat "$PID_FILE") 2>/dev/null
rm -f "$LOG" "$PID_FILE"

# Start tunnel in background
cloudflared tunnel --url http://localhost:$PORT --no-autoupdate > "$LOG" 2>&1 &
echo $! > "$PID_FILE"

# Wait for URL to appear in logs
for i in {1..20}; do
  URL=$(grep -o 'https://[^[:space:]]*trycloudflare\.com' "$LOG" 2>/dev/null | head -1)
  if [ -n "$URL" ]; then
    echo "$URL"
    exit 0
  fi
  sleep 1
done

echo "ERROR: URL not found. Check $LOG" >&2
exit 1
