#!/bin/bash
# Deploy a directory to Cloudflare Pages
# Usage: ./deploy-page.sh /path/to/html/directory [project-name]

set -e

if [ -z "$1" ]; then
  echo "Usage: $0 /path/to/html/directory [project-name]"
  exit 1
fi

DIR="$1"

if [ ! -d "$DIR" ]; then
  echo "Error: Directory not found: $DIR"
  exit 1
fi

# Default project name or use provided
if [ -n "$2" ]; then
  PROJECT="$2"
else
  PROJECT="trace-$(date +%Y%m%d-%H%M%S)"
fi

# Load credentials
export CLOUDFLARE_API_TOKEN="IsWQg-M_9YJ6EoQSxCWzi_aw8ugmCzBopdOH74mH"

# Check if project exists, create if not
if ! wrangler pages project list 2>&1 | grep -q "$PROJECT"; then
  echo "Creating new project: $PROJECT"
  wrangler pages project create "$PROJECT" --production-branch main
fi

# Deploy
echo "Deploying $DIR to $PROJECT..."
cd "$DIR"
wrangler pages deploy . --project-name "$PROJECT"

echo ""
echo "✅ Deployment complete!"
echo "Live at: https://$PROJECT.pages.dev"
