# Cloudflare Tools for Trace

All three systems are ready! ✅

---

## Quick Tunnels ✅

Expose local ports instantly with a public URL. No account needed.

**Start a tunnel:**
```bash
./start-tunnel.sh [PORT]
# Example: ./start-tunnel.sh 3000
# Returns: https://random-name.trycloudflare.com
```

**Stop tunnel:**
```bash
./stop-tunnel.sh
```

**Common patterns:**

*Share a file:*
```bash
python3 -m http.server 8080 --directory /tmp/output &
URL=$(./start-tunnel.sh 8080)
echo "Download: $URL"
```

*Expose a web app:*
```bash
npm run dev &  # starts on localhost:3000
URL=$(./start-tunnel.sh 3000)
echo "Share: $URL"
```

---

## R2 File Storage ✅

Zero-egress object storage. 10GB free, unlimited downloads.

**Bucket:** `trace-artifacts`  
**Public URL:** `https://pub-0bf7a1971eff42b9a061b943afefcdb3.r2.dev`

**Upload a file:**
```bash
./upload-r2.sh /path/to/file.pdf
# Or with custom name:
./upload-r2.sh /path/to/file.pdf report-2026-02-27.pdf
```

The script will return a public URL automatically.

**Note:** If you get a 404 when accessing uploaded files:
- Public access may still be propagating (give it a few minutes)
- Or verify in dashboard: https://dash.cloudflare.com → R2 → trace-artifacts → Settings → Public Access is enabled

**Direct CLI:**
```bash
wrangler r2 object put trace-artifacts/myfile.txt --file /tmp/myfile.txt
# Public URL: https://pub-0bf7a1971eff42b9a061b943afefcdb3.r2.dev/myfile.txt
```

---

## Pages Hosting ✅

Deploy static HTML/JS sites instantly. Free, CDN-backed.

**Deploy a page:**
```bash
./deploy-page.sh /path/to/html/directory
# Or with custom project name:
./deploy-page.sh /tmp/report trace-analysis
```

**Test deployment live:**
https://e2f9ca33.trace-test.pages.dev

**Direct CLI:**
```bash
# Create project
wrangler pages project create my-project --production-branch main

# Deploy
cd /path/to/html
wrangler pages deploy . --project-name my-project
```

---

## Quick Examples

**Generate + deploy a report:**
```bash
# Generate HTML
mkdir -p /tmp/report
cat > /tmp/report/index.html << 'EOF'
<!DOCTYPE html>
<html>
<head><title>Analysis</title></head>
<body>
<h1>Competitor Analysis - Feb 2026</h1>
<p>Your analysis here...</p>
</body>
</html>
EOF

# Deploy to Pages
./deploy-page.sh /tmp/report competitor-feb2026
# Returns: https://competitor-feb2026.pages.dev (or similar)
```

**Upload + share a file:**
```bash
# Upload dataset to R2
./upload-r2.sh /tmp/research-data.zip
# Returns: https://pub-0bf7a1971eff42b9a061b943afefcdb3.r2.dev/research-data.zip

# OR share via Quick Tunnel (temp)
python3 -m http.server 8080 --directory /tmp &
URL=$(./start-tunnel.sh 8080)
echo "Download: $URL/research-data.zip"
./stop-tunnel.sh  # when done
```

---

## Credentials

**Account:** hnshah@gmail.com  
**Account ID:** `6c9806b61a3497a147f218e7e00cbcae`  
**API Token:** Saved in `~/.bashrc` (auto-loaded)

**View/manage:**
- Dashboard: https://dash.cloudflare.com
- API Tokens: https://dash.cloudflare.com/profile/api-tokens
- R2 Buckets: https://dash.cloudflare.com → R2
- Pages Projects: https://dash.cloudflare.com → Pages

---

## Helper Scripts

- `start-tunnel.sh` - Quick Tunnel (ephemeral URLs)
- `stop-tunnel.sh` - Stop Quick Tunnel
- `upload-r2.sh` - Upload file to R2 (returns public URL)
- `deploy-page.sh` - Deploy HTML to Pages

---

## Reference

Full guide: `/root/.openclaw/workspace/docs/CLOUDFLARE-BOT-GUIDE.md`

Cloudflare docs:
- Workers: https://developers.cloudflare.com/workers/
- R2: https://developers.cloudflare.com/r2/
- Pages: https://developers.cloudflare.com/pages/
- Tunnels: https://developers.cloudflare.com/cloudflare-one/connections/connect-apps/
