# Cloudflare for Bots — Complete Reference

**Everything a bot can do with Cloudflare, organized by what requires an account and why you'd use each capability.**

---

## The Map (Start Here)

| I need to... | Use | Account? |
|---|---|---|
| Expose a local port right now | Quick Tunnel | None |
| Receive webhooks from a service | Quick Tunnel or Named Tunnel | None / Free |
| Share a live running app | Quick Tunnel | None |
| Have a stable URL across restarts | Named Tunnel | Free |
| Use my own domain (e.g. bot.mysite.com) | Named Tunnel + DNS | Free |
| Store and serve files (no egress costs) | R2 | Free |
| Share state between bots | KV Store | Free |
| Run a function at the edge permanently | Workers | Free |
| Deploy a static HTML dashboard/report | Pages | Free |
| Add auth to any URL (Google SSO, etc.) | Access | Free |
| Cache and log LLM API calls | AI Gateway | Free |
| Store structured data that outlives a session | D1 (SQLite) | Free |
| Forward emails to a webhook | Email Routing | Free |

---

## Quick Reference: What's Installed

✅ **cloudflared** v2026.2.0 (Quick Tunnels ready)  
✅ **wrangler** (Pages + R2 CLI ready)

**Location:** `/root/.openclaw/workspace/tools/cloudflare/`
- `start-tunnel.sh` - Start Quick Tunnel
- `stop-tunnel.sh` - Stop Quick Tunnel
- `README.md` - Quick usage guide

---

[Full content from the guide continues here...]

For the complete reference including all features, decision trees, and detailed examples, see the original guide or visit Cloudflare docs.
